
function Switch_P_V()

% This function switchs on/off the Gilson valve and Harvard pump
% sequentially for a calculated flow amount to be pumped inside the 
% microfluidic chamber. the flow time is set to 1 seconds and is changable
% as well as the comport number for both valve and pump.

% % Setup serial communication with valve
s2 = serial('COM10');
set(s2,'DataBits',8);
set(s2,'StopBits',2);
set(s2,'BaudRate',9600);
set(s2,'Parity','none');
fopen(s2);
fprintf(s2,'%c','I'); % open the valve (inject beads to microfluidic chamber)
              
% % Setup serial communication with pump
disp('start flow')
s1 = serial('COM8');
fopen(s1);
fprintf(s1,'%s\r','RUN');
pause(1);%%% flow time 
fprintf(s1,'%s\r','STOP');
fclose(s1);
delete(s1);
disp('stop flow')
        
fprintf(s2,'%c','L'); % close the valve (load beads back to the syringe)
fclose(s2);
        

               
             
        